var g_loginCtl = new Object();
var g_loginFailCtl = new Object();
var VAL_USER_ADMIN = "Administrator";
var VAL_USER_GUEST = "Guest";
var KEY_USER_TYPE = "snmpUser";

g_loginCtl.MAX_KEEP_SEC = 3000;
g_loginCtl.CONFIRM_KEEP_SEC = 10;
g_loginCtl.sec = 0;
g_loginCtl.confirmIng = false;
g_loginCtl.confirmSec = 0;

function initLoginFailCtl(){
	g_loginFailCtl.MIN_TRY_SEC = 300;
	g_loginFailCtl.MAX_TRY_CENT = 5;
	g_loginFailCtl.sec = 0;
	g_loginFailCtl.failCent = 0;
	g_loginFailCtl.needInitWait = true;
	g_loginFailCtl.needEnRelogin = true;
}

function loginFailCheck(){
	if(g_loginFailCtl.failCent>=g_loginFailCtl.MAX_TRY_CENT){
		if(g_loginFailCtl.needInitWait){
			g_loginFailCtl.needInitWait = false;
			$("#password").attr("disabled","disabled");
			$("#loginButton").attr("disabled","disabled");
			//var times = g_loginFailCtl.failCent-g_loginFailCtl.MAX_TRY_CENT;
			//g_loginFailCtl.sec = g_loginFailCtl.MIN_TRY_SEC<<times;
		}else{
			if(g_loginFailCtl.sec==0){
				if(g_loginFailCtl.needEnRelogin){
					g_loginFailCtl.needEnRelogin = false;
					$("#password").removeAttr("disabled");
					$("#loginButton").removeAttr("disabled");
					$("#errorTip").text("");
				}
			}else{
				g_loginFailCtl.sec--;
				$("#errorTip").text("Please try after "+g_loginFailCtl.sec + " sec.");
			}
		}
	}
}		

function login(){
	var pwd = $.trim(encodeURIComponent($("#password").val()));
	if (!checkPwd()) {
	  return;
	}
	var url = "/cgi-bin/rtControl.cgi?name=password&?params=" + pwd + "&"+Math.random();
	$.get(url,function(data){
		if(data != null && data != "null" && data != ""){
			var r_v = data.split("\n");
			var r_vl = r_v[1];
			if (r_vl == "(ACK") {
				showAdmin();
				initLoginFailCtl();
			} else {
				alert("Login failure!");
				//g_loginFailCtl.failCent++;
				g_loginFailCtl.needInitWait=true;
				g_loginFailCtl.needEnRelogin = true;
			}
			g_loginFailCtl.sec = r_v[2];
			g_loginFailCtl.failCent = r_v[3];
			if(r_v[4]==0){
				g_loginFailCtl.needInitWait = true;
				g_loginFailCtl.needEnRelogin = true;
			}else{
				g_loginFailCtl.needInitWait = false;
				g_loginFailCtl.needEnRelogin = false;
			}
		}
	});
	/*
	var url1="/cgi-bin/getprotocolid.cgi"+ "?sid=" + Math.random();
	$.get(url1,function(data){
		if(data != null && data != "null" && data != ""){
			var r_v = data.split("\n");
			g_loginFailCtl.sec = r_v[4];
			g_loginFailCtl.failCent = r_v[5];
			if(r_v[6]==0){
				g_loginFailCtl.needInitWait = true;
				g_loginFailCtl.needEnRelogin = true;
			}else{
				g_loginFailCtl.needInitWait = false;
				g_loginFailCtl.needEnRelogin = false;
			}
		}
	});
	*/
}


function resetConfirmDiv(){
	hiddenDiv();
	$("#loginButton").val("Login");
	$("#loginButton").attr("onclick","login();");
	$("#clearButton").val("Clear");
	$("#clearButton").attr("onclick","clearPwd();");
	$("#forgotpwd").show();
	$("#errorTip").text("");
	$("#password").val("");
	$("#closeBut").attr("onclick","hiddenDiv();");
	$("#password").removeAttr("disabled");
	g_loginCtl.confirmIng = false;
}

function onConfirmContinue(){
	g_loginCtl.sec = 0;
	resetConfirmDiv();
}

function onConfirmLogout(){
	resetConfirmDiv();
	logout();
}

function logoutConfirm(){
	if(g_loginCtl.confirmIng){
		if(g_loginCtl.confirmSec > 0){
			if(g_loginCtl.confirmSec == g_loginCtl.CONFIRM_KEEP_SEC){
				$("#loginButton").val("Continue");
				$("#loginButton").attr("onclick","onConfirmContinue();");
				$("#clearButton").val("Logout");
				$("#clearButton").attr("onclick","onConfirmLogout();");
				$("#forgotpwd").hide();
				$("#password").val("00000000");
				$("#closeBut").attr("onclick","");
				$("#password").attr("disabled","disabled");
				loginDiv();
			}
			
			$("#errorTip").text("Auto logout after "+g_loginCtl.confirmSec + " sec.");	
			g_loginCtl.confirmSec--;
		}else{
			onConfirmLogout();
		}
	}	
}

function logout(){
	$("#loginSpan").html("<a href='javascript:;' onclick='loginDiv();'>Login</a>");
	$("#loginType").html(VAL_USER_GUEST);
	$("#userType").val(VAL_USER_GUEST);
	sessionStorage.setItem(KEY_USER_TYPE,VAL_USER_GUEST);
}
		
function autoLogout(){
	if($("#userType").val() == VAL_USER_ADMIN){
		if(g_loginCtl.sec++ >= g_loginCtl.MAX_KEEP_SEC){
			g_loginCtl.sec = 0;
			g_loginCtl.confirmSec = g_loginCtl.CONFIRM_KEEP_SEC;
			g_loginCtl.confirmIng = true;
			
		
		}
		logoutConfirm();
	}
}

function doIn1SecTimer(){
	autoLogout();
	loginFailCheck();
}

function doMouseMove(){
	g_loginCtl.sec = 0;
}

function showAdmin(){
	$("#loginSpan").html("<a href='javascript:;' onclick='logout();'>Logout</a>");
	$("#loginType").html(VAL_USER_ADMIN);
	$("#userType").val(VAL_USER_ADMIN);
	sessionStorage.setItem(KEY_USER_TYPE,VAL_USER_ADMIN);
	hiddenDiv();
}

function hiddenDiv() {
	$("#boxDIV").hide();
	$("#mbDIV").hide();
	clearPwd();
}

function loginDiv() {
	$("#boxDIV").css("left",(document.body.clientWidth - 350) / 2);
	$("#boxDIV").show();
	$("#mbDIV").show();
}

function clearPwd() {
	$("#password").val("");
}

function checkPwd() {
	var pwd = $.trim(encodeURIComponent($("#password").val()));
	
	var PwdLength = pwd.length - 2*(pwd.split("%").length-1);
	if (PwdLength < 8) {
		$("#errorTip").html("Password less than 8.");
		return false;
	} else {
		$("#errorTip").html("");
	}
	
	return true;
}

$(function(){
	$(document).mousemove(doMouseMove);
	$("#showpage").on("load",function(){
		var document = $("#showpage").prop("contentWindow").document.body;
		$(document).mousemove(doMouseMove);
	});
	initLoginFailCtl();
	if(sessionStorage.getItem(KEY_USER_TYPE)==VAL_USER_ADMIN){
		showAdmin();
	}

	setInterval(doIn1SecTimer,1000);
});