// power flow func
function initPowerFlow()
{
	ds("acloss");
	ds("overload");
	ds("batteryloss");
	ds("right_arrow_1");
	ds("right_arrow_2");
	ds("leftdown");
	ds("leftdownup");
	ds("upleft");
	ds("upright");
	ds("down1");
	ds("down2");
	ds("downupdown");
	ds("up1");
	ds("up2");
	ds("leftup");
	ds("downright");
	ds("faultmode");
}
function rePowerFlow(workinfo)
{
	var workMode = workinfo.workMode;
	if(workinfo.prodid != 18){
		if(workMode == "Standby without charging")
		{
			showStandbyWithoutCharging(workinfo);
		}
		else if(workMode == "Standby with PV charging")
		{
			showStandbyWithPVCharging(workinfo);
		}
		else if(workMode == "Standby with AC charging")
		{
			showStandbyWithACCharging(workinfo);
		}
		else if(workMode == "Bypass without charging")
		{
			showBypassWithoutCharging(workinfo);
		}
		else if(workMode == "Bypass with PV charging")
		{
			showBypassWithPVCharging(workinfo);
		}
		else if(workMode == "Bypass with AC charging")
		{
			showBypassWithACCharging(workinfo);
		}
		else if(workMode == "Grid-tie with backup")
		{	
			showGridtiewithBackup(workinfo);
		}
		else if(workMode == "Inverter")
		{
			showInverterMode(workinfo);
		}
		else if(workMode == "Power On")
		{
			showPowerOnMode(workinfo);
		}
		else
		{
			initPowerFlow();
		}
	}else {
		if(workMode == "Power On")
		{
			showPowerOnMode(workinfo);
		}else if(workMode == "Standby"){
			showStandbyMode(workinfo);
		}else if(workMode == "Bypass"){
			showBypassMode(workinfo);
		}else if(workMode == "Battery"){
			showBetteryMode(workinfo);
		}else if(workMode == "Fault"){
			showFaultMode(workinfo);
		}else if(workMode == "Hybrid"){
			showHybridMode(workinfo);
		}else
		{
			initPowerFlow();
		}
		
		
		
	}
}
function showStandbyWithoutCharging(workinfo)
{
	initPowerFlow();
	if(workinfo.overLoad)
	{
		en("overload");
	}
	if(workinfo.lineLoss)
	{
		en("acloss");
	}
	if(workinfo.noBattery)
	{
		en("batteryloss");
	}
	if(workinfo.fault)
	{
		en("faultmode");
	}
}

function showStandbyWithPVCharging(workinfo)
{
	showStandbyWithoutCharging(workinfo);
	if(!workinfo.pvLoss && workinfo.batteryStatus=="01")
	{
		en("right_arrow_1");
		en("leftdown");
		en("down2");
	}
}

function showStandbyWithACCharging(workinfo)
{
	showStandbyWithoutCharging(workinfo);
	if(!workinfo.lineLoss && workinfo.batteryStatus=="01")
	{
		en("upleft");
		en("down1");
		en("leftdown");
		en("down2");
	}
}

function showBypassWithoutCharging(workinfo)
{
	showStandbyWithoutCharging(workinfo);
	if(!workinfo.lineLoss && workinfo.hasLoad)
	{
		en("down1");
		en("upright");
		en("right_arrow_2");
	}
}

function showBypassWithPVCharging(workinfo)
{
	showStandbyWithoutCharging(workinfo);
	if(!workinfo.lineLoss && workinfo.hasLoad)
	{
		en("down1");
		en("upright");
		en("right_arrow_2");
	}
	if(!workinfo.pvLoss && workinfo.batteryStatus=="01")
	{
		en("right_arrow_1");
		en("leftdown");
		en("down2");
	}
}

function showBypassWithACCharging(workinfo)
{
	showStandbyWithoutCharging(workinfo);
	if(!workinfo.lineLoss && workinfo.hasLoad)
	{
		en("down1");
		en("upright");
		en("right_arrow_2");
	}
	if(!workinfo.lineLoss && workinfo.batteryStatus=="01")
	{
		en("down1");
		en("upleft");
		en("leftdown");
		en("down2");
	}
}

function showGridtiewithBackup(workinfo)
{
	showStandbyWithoutCharging(workinfo);
	if(workinfo.prodid == 16 || workinfo.prodid == 17 || workinfo.prodid == 18)
	{
		if(workinfo.hasLoad)
		{
			
			en("upright");
			en("right_arrow_2");
		}
		
		if(workinfo.lineDirection == "00")
		{
			en("downupdown");
		}
		else if(workinfo.lineDirection == "01")
		{
			en("down1");
		}
		else if(workinfo.lineDirection == "02")
		{
			en("up1");
		}
		
		if(workinfo.invDirection == "0")
		{
			en("leftup");
		}
		else if(workinfo.invDirection == "1")
		{
			en("upleft");
		}
		
		if(!workinfo.pvLoss)
		{
			en("right_arrow_1");
			
			if(!workinfo.noBattery && workinfo.batteryStatus=="01")
			{
				en("leftdown");
				en("down2");
			}
		}
		else
		{
			if(!workinfo.noBattery && workinfo.batteryStatus=="02")
			{
				en("up2");
				en("leftdownup");
			}
		}
	}
}

function showInverterMode(workinfo)
{
	initPowerFlow();
	if(workinfo.overLoad)
	{
		en("overload");
	}
	if(workinfo.lineLoss)
	{
		en("acloss");
	}
	if(workinfo.fault)
	{
		en("faultmode");
	}
	if(workinfo.noBattery)
	{
		en("batteryloss");
		en("right_arrow_1");
		en("leftdown");
		en("downright");
		en("right_arrow_2");
	}
	else
	{

		if(!workinfo.pvLoss)
		{
			en("right_arrow_1");
			en("leftdown");
		}
		
		if(workinfo.batteryStatus == "00")
		{
			//en("downupdown");
		}
		else if(workinfo.batteryStatus == "01")
		{
			en("down2");
		}
		else if(workinfo.batteryStatus == "02")
		{
			en("up2");
		}
		
		if(workinfo.hasLoad)
		{
			en("downright");
			en("right_arrow_2");
		}
	}
}
// P18
function showPowerOnMode(workinfo)
{
	initPowerFlow();

	if(workinfo.overLoad)
	{
		en("overload");
	}else{
		ds("overload");
	}
	if(workinfo.lineLoss)
	{
		en("acloss");
	}else{
		ds("acloss");
	}
}

function showStandbyMode(workinfo)
{
	initPowerFlow();
	if(workinfo.invDirection == "2"){
		showHybridMode(workinfo);
		return;
	}
	
	if(!workinfo.pvLoss){
		en("right_arrow_1");
		en("leftdown");
		en("down2");
	}else{
		ds("right_arrow_1");
	}
	
	if(!workinfo.pvLoss && workinfo.invDirection == "1"){
		en("down1");
		en("upleft");
		en("leftdown");
		en("down2");
	}else{
		ds("down1");
		ds("upleft");
	}
	
	if(workinfo.lineLoss&& workinfo.pvLoss){
		ds("leftdown");
		ds("down2");
	}
	
	if(workinfo.lineLoss){
		en("acloss");
	}else{
		ds("acloss");
	}
	
	if(workinfo.overLoad){
		en("overload");
	}else{
		ds("overload");
	}
}

function showBypassMode(workinfo)
{
	initPowerFlow();
	if(workinfo.fault)
	{
		en("faultmode");
	}else{
		ds("faultmode");	
	}
	if(workinfo.lineLoss){
		en("acloss");
	}else{
		ds("acloss");
	}
	if(workinfo.noBattery)
	{
		en("batteryloss");
	}else{
		ds("batteryloss");
	}
	if(workinfo.overLoad){
		en("overload");
	}else{
		ds("overload");
	}
	if(!workinfo.lineLoss && workinfo.hasLoad)
	{
		en("down1");
		en("upright");
		en("right_arrow_2");
	}else{
		ds("down1");
		ds("upright");
		ds("right_arrow_2");
	}

	if(!workinfo.lineLoss && !workinfo.noBattery){
		en("upleft");
		en("leftdown");
		ds("leftdownup");
		en("down2");
	}else{
		ds("upleft");
		ds("leftdown");
		ds("leftdownup");
		ds("down2");
	}
		
	if(!workinfo.pvLoss && !workinfo.noBattery){
		en("right_arrow_1");
		en("down2");
		en("leftdown");
		ds("leftdownup");
	}
	if(workinfo.batteryStatus == "00")
	{
		ds("down2");
		ds("up2");
	}
	else if(workinfo.batteryStatus == "01")
	{
		en("down2");
		ds("up2");
	}
	else if(workinfo.batteryStatus == "02")
	{
		ds("down2");
		en("up2");
	}


}

function showBetteryMode(workinfo)
{
	initPowerFlow();
	if(!workinfo.pvLoss){
		en("right_arrow_1");
		en("leftdown");
	}else{
		ds("right_arrow_1");
		ds("leftdown");
	}
	en("right_arrow_2");
	en("downright");
	
	if(workinfo.lineLoss){
		en("acloss");
	}else{
		ds("acloss");
	}
	if(workinfo.overLoad){
		en("overload");
	}else{
		ds("overload");
	}
	
	if(workinfo.batteryStatus == "00")
	{
		ds("down2");
		ds("up2");
	}
	else if(workinfo.batteryStatus == "01")
	{
		en("down2");
		ds("up2");
	}
	else if(workinfo.batteryStatus == "02")
	{
		ds("down2");
		en("up2");
	}
}

function showFaultMode(workinfo)
{
	initPowerFlow();
	if(!workinfo.pvLoss){
		en("right_arrow_1");
		en("leftdown");
		en("down2");
	}else{
		ds("right_arrow_1");
		ds("leftdown");
		ds("down2");
	}
	en("faultmode");
	if(workinfo.lineLoss){
		en("acloss");
	}else{
		ds("acloss");
	}
	if(workinfo.overLoad){
		en("overload");
	}else{
		ds("overload");
	}
	
}

function showHybridMode(workinfo){
	initPowerFlow();
	if(workinfo.invDirection == "2"){
		ds("upleft");
		if(workinfo.batteryStatus == "01")
		{
			en("leftdown");
			ds("leftdownup");
			en("down2");
			ds("up2");
		}
		else if(workinfo.batteryStatus == "02")
		{
			ds("leftdown");
			en("leftdownup");
			ds("down2");
			en("up2");
		}
		else if(workinfo.batteryStatus == "00")
		{
			ds("leftdown");
			ds("leftdownup");
			ds("down2");
			ds("up2");
		}
		
		en("leftup");
			//是否带载
		if(workinfo.hasLoad)
		{
			ds("downright");
			en("upright");
			en("right_arrow_2");
		}
		else
		{
			ds("downright");
			ds("upright");
			ds("right_arrow_2");
		}
		
		if(!workinfo.lineLoss)
		{
			
			//AC方向
			if(workinfo.lineDirection == "00")
			{
				ds("downupdown");
				ds("down1");
				ds("up1");
			}
			else if(workinfo.lineDirection == "01")
			{
				if(workinfo.batteryStatus == "02"){
					ds("downupdown");
					ds("down1");
					ds("up1");
					en("leftdownup");
				}else{
					//AC输入
					ds("downupdown");
					en("down1");
					ds("up1");
					ds("leftdownup");
				}
			}
			else if(workinfo.lineDirection == "02")
			{
					//并网
				ds("downupdown");
				ds("down1");
				en("up1");
			}
			
		}
		else
		{
			ds("downupdown");
			ds("down1");
			ds("up1");
		}
	}else if(workinfo.invDirection == "1"){
					//AC - DC
			ds("leftup");
			en("upleft");
			//是否带载
			if(workinfo.hasLoad)
			{
				en("upright");
				en("right_arrow_2");
			}
			else
			{
				ds("upright");
				ds("right_arrow_2");
			}
			
			if(workinfo.batteryStatus == "01")
			{
				en("leftdown");
				ds("leftdownup");
				en("down2");
				ds("up2");
			}
			else if(workinfo.batteryStatus == "02")
			{
				ds("leftdown");
				//en("leftdownup");
				ds("down2");
				en("up2");
			}
			else if(workinfo.batteryStatus == "00")
			{
				ds("leftdown");
				//ds("leftdownup");
				ds("down2");
				ds("up2");
			}
			
			if(!workinfo.lineLoss)
			{
				//AC方向
				if(workinfo.lineDirection == "02")
				{
						//并网
					ds("downupdown");
					ds("down1");
					en("up1");
				}
				else if(workinfo.lineDirection == "01")
				{
					ds("downupdown");
					en("down1");
					ds("up1");
				}else if(workinfo.lineDirection == "00")
				{
					ds("downupdown");
					ds("down1");
					ds("up1");
				}

			}
			else
			{
					ds("downupdown");
					ds("down1");
					ds("up1");
			}
		
	}else{
			ds("leftup");
			ds("upleft");
			ds("upright");
			ds("right_arrow_2");
			
			if(workinfo.batteryStatus == "01")
			{
				en("leftdown");
				ds("leftdownup");
				en("down2");
				ds("up2");
			}
			else if(workinfo.batteryStatus == "02")
			{
				ds("leftdown");
				en("leftdownup");
				ds("down2");
				en("up2");
			}
			else if(workinfo.batteryStatus == "00")
			{
				ds("leftdown");
				ds("leftdownup");
				ds("down2");
				ds("up2");
			}
			
			//是否带载
			if(workinfo.hasLoad && workinfo.lineDirection == "01")
			{
				ds("downright");
				en("upright");
				ds("leftup");
				en("right_arrow_2");
				
				//AC输入
				ds("downupdown");
				en("down1");
				ds("up1");
			}
			else
			{
				ds("downright");
				ds("upright");
				ds("leftup");
				ds("right_arrow_2");
				//AC输入
				ds("downupdown");
				ds("down1");
				ds("up1");
			}
			
	}
	if(!workinfo.pvLoss)
	{
		//PV充电
		if((workinfo.pv1status == '2' || workinfo.pv1status == '2'))
		{
			en("right_arrow_1");
		}
		else
		{
			ds("right_arrow_1");
		}
	}
	else
	{
		ds("right_arrow_1");
	}
	
	if(workinfo.lineLoss){
		en("acloss");
	}else{
		ds("acloss");
	}
	if(workinfo.overLoad){
		en("overload");
	}else{
		ds("overload");
	}
}
//power flow fun end
